echo off
cls
echo.
echo this batch file executes PCSDL with predetermined settings/args
echo.
echo procedure for SDL:
echo                     1.  prepare all necessary files
echo                     2.  turn OFF the card to be SDL'ed
echo                     3.  execute this bat file
echo                     4.  turn ON the card to be SDL'ed


rem Notes:
rem     1.  upon powering up, the target will listen for SDL request sequence
rem         for about 2 seconds; it is likely that the card may have not received
rem         the SDL request, try a few times
rem     2.  if the 2 second period expired and there was no SDL request, the
rem         boot code will try to list all files exists on flash file sys

rem In case of difficulties:
rem     1.  PCSDL requires HW flow control - insure that the serial cable supports it
rem     2.  check PC port for correct IRQ and such
rem     3.  it is likely that the card may have not received the SDL request, repeat
rem         step 2, 3, 4


rem assumptions:
rem         - curr dir contains:
rem                 - PCSDL.EXE     - PCSDL executible
rem                 - TTxxyyzz.sdl  - PCSDL Agent
rem                 - TTxxyyzz.nac  - code to load
rem			TT = 2 character target prefix
rem			xx = major revision of NAC/SDL
rem			yy = minor revision of NAC/SDL
rem			zz = update number of NAC/SDL

if not "%1"=="115" goto is_192
set BAUDRATE=115200
goto check_HW

:is_192
if not "%1"=="192" goto is_384
set BAUDRATE=19200
goto check_HW

:is_384
if not "%1"=="384" goto is_576
set BAUDRATE=38400
goto check_HW

:is_576
if not "%1"=="576" goto is_24
set BAUDRATE=57600
goto check_HW

:is_24
if not "%1"=="24" goto error_msg
set BAUDRATE=2400
goto check_HW

:check_HW
echo.
echo download TARGET=%2
echo running pcsdl with port 1 at %BAUDRATE%
echo.

REM Unless you have a 16550AF UART, disable UART FIFO
REM to enable UART FIFO remove the "-b" option

pcsdl -p1 -r%BAUDRATE% -vNA2.0.0 -vSD0.1.0 -nSD%2 -nNA%2
goto done

:error_msg
echo.
echo usage:      dl [baud target]
echo             baud = 115, 115200 ; 576, 57600 ; 384, 38400 ; OR 192, 19200
echo             target: mr = OCR812
:done

rem Clear environment
set TARGET=
set BAUDRATE=

echo on
